package main

import (
	"fmt"
	"unsafe"
)

// Struktura OrderInfo ma wielkość całkowitą 56 bajtów
type OrderInfo struct {
	OrderCode   rune     // 4 bajty plus 4 bajty dopełnienia
	Amount      int      // 8 bajty, bez dopełnienia
	OrderNumber uint16   // 2 bajty plus 6 bajtów dopełnienia
	Items       []string // 24 bajty, bez dopełnienia
	IsReady     bool     // 1 bajt plus 7 bajtów dopełnienia
}

func main() {
	// Wyświetlenie wielkości struktury OrderInfo
	info := OrderInfo{}
	fmt.Println("Size of OrderInfo:", unsafe.Sizeof(info))

	// Wyświetlenie przesunięcia poszczególnych pól w strukturze OrderInfo
	fmt.Println("Offset of OrderCode:", unsafe.Offsetof(info.OrderCode))
	fmt.Println("Offset of Amount:", unsafe.Offsetof(info.Amount))
	fmt.Println("Offset of OrderNumber:", unsafe.Offsetof(info.OrderNumber))
	fmt.Println("Offset of Items:", unsafe.Offsetof(info.Items))
	fmt.Println("Offset of IsReady:", unsafe.Offsetof(info.IsReady))
}

// Struktura SmallOrderInfo ma wielkość całkowitą 40 bajtów
type SmallOrderInfo struct {
	IsReady     bool     // 1 bajt plus 1 bajt dopełnienia
	OrderNumber uint16   // 2 bajty, bez dopełnienia
	OrderCode   rune     // 4 bajty, bez dopełnienia
	Amount      int      // 8 bajtów, bez dopełnienia
	Items       []string // 24 bajty, bez dopełnienia
}
